let ulElementi = document.querySelector("ul");
let liElementi = document.querySelectorAll("li");
let inputTask = document.getElementById("task");
let radioPocetak = document.getElementById("pocetak");

inputTask.addEventListener("keyup", (e) => {
    e.preventDefault();
    // console.log(e);
    if(e.key == "Enter") {
        let tekstObaveze = inputTask.value;

        // Dodavanje elementa na kraj liste može se uraditi na dva načina:
        // 1. način
        // let liTekstObaveze = `<li>${tekstObaveze}</li>`;
        // ulElementi.innerHTML += liTekstObaveze;

        // 2. način
        // let elementLI = document.createElement("li"); // kreira prazan čvor list item (prazan HTML element li)
        // elementLI.textContent = tekstObaveze; // upizujem vrednost u kreirani element
        // ulElementi.prepend(elementLI); // .append - dodaje čvor na kraj roditeljskog elementa (poslednje dete u roditelju)
        //                              //.prepend() - dodaje čvor na početak roditeljskog elementa (prvo dete u roditelju)
    

        // Dodavanje na početak ili kraj liste, u zavisnosti od odabrane opcije
        let elementLI = document.createElement("li"); // kreira prazan čvor list item (prazan HTML element li)
        elementLI.textContent = tekstObaveze; // upizujem vrednost u kreirani element
        if(radioPocetak.checked) {
            ulElementi.prepend(elementLI);
        }
        else {
            ulElementi.append(elementLI);
        }

        inputTask.value = ""; // isprazni input polje
    }
});

// NE RADI ZA NOVODODATE ELEMENTE
// liElementi.forEach(li => {
//     li.addEventListener("click", () => {
//         // 1. Način
//         // if(li.style.textDecoration == "line-through") {
//         //     li.style.textDecoration = "none"; // otprecrtaj
//         // } else {
//         //     li.style.textDecoration = "line-through" // precrtaj
//         // }

//         // 2. Način
//         // li.classList - vraća sve klase koje element poseduje
//         li.classList.toggle("precrtaj"); // radi kao prekidač, ako element ne poseduje klasu "precrtaj" dodaje je, ako element poseduje kalsu "precrtaj" skloni je sa elementa
//     });
// });

ulElementi.addEventListener("click", (e) => {
    let ceoElement = e.target;
    let tagElementa = e.target.tagName; // drugim rečima let tagElementa = ceoElement.tagName;
    if(tagElementa == "LI") {
        ceoElement.classList.toggle("precrtaj");
    }
    

});


